/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.RegexCache;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.ToStringCondensed;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class ResourceIdentifier<STACK, ITEM, CAP>
implements ASTNode,
ToStringCondensed {
    public static final ResourceIdentifier<?, ?, ?> MATCH_ALL = new ResourceIdentifier(".*", ".*");
    private static final Map<ResourceIdentifier<?, ?, ?>, List<ResourceIdentifier<?, ?, ?>>> expansionCache = new Object2ObjectOpenHashMap();
    public final String resourceTypeNamespace;
    public final String resourceTypeName;
    public final String resourceNamespace;
    public final String resourceName;
    private final Predicate<String> resourceNamespacePredicate;
    private final Predicate<String> resourceNamePredicate;
    @Nullable
    private ResourceType<STACK, ITEM, CAP> resourceTypeCache = null;

    public ResourceIdentifier(String resourceTypeNamespace, String resourceTypeName, String resourceNamespace, String resourceName) {
        resourceTypeNamespace = resourceTypeNamespace.toLowerCase(Locale.ROOT);
        resourceTypeName = resourceTypeName.toLowerCase(Locale.ROOT);
        List<String> check = List.of("fe", "rf", "energy", "power");
        if (resourceTypeNamespace.equals("sfm") && check.contains(resourceTypeName)) {
            resourceTypeName = "forge_energy";
        }
        this.resourceTypeNamespace = resourceTypeNamespace;
        this.resourceTypeName = resourceTypeName;
        this.resourceNamespace = resourceNamespace;
        this.resourceName = resourceName;
        this.resourceNamespacePredicate = RegexCache.buildPredicate(resourceNamespace);
        this.resourceNamePredicate = RegexCache.buildPredicate(resourceName);
    }

    public ResourceIdentifier(ResourceLocation resourceTypeKey, ResourceLocation resourceKey) {
        this(resourceTypeKey.getNamespace(), resourceTypeKey.getPath(), resourceKey.getNamespace(), resourceKey.getPath());
    }

    public ResourceIdentifier(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeKey, ResourceLocation resourceKey) {
        this(resourceTypeKey.location().getNamespace(), resourceTypeKey.location().getPath(), resourceKey.getNamespace(), resourceKey.getPath());
    }

    public ResourceIdentifier(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeKey, ResourceKey<?> resourceKey) {
        this(resourceTypeKey.location().getNamespace(), resourceTypeKey.location().getPath(), resourceKey.location().getNamespace(), resourceKey.location().getPath());
    }

    public ResourceIdentifier(String value) {
        this("sfm", "item", ".*", value);
    }

    public ResourceIdentifier(String namespace, String value) {
        this("sfm", "item", namespace, value);
    }

    public ResourceIdentifier(String typeName, String resourceNamespace, String resourceName) {
        this("sfm", typeName, resourceNamespace, resourceName);
    }

    public boolean matchesResourceLocation(ResourceLocation stackId) {
        return this.resourceNamePredicate.test(stackId.getPath()) && this.resourceNamespacePredicate.test(stackId.getNamespace());
    }

    public static <STACK, ITEM, CAP> ResourceIdentifier<STACK, ITEM, CAP> fromString(String string) {
        String[] parts = string.split(":");
        if (parts.length == 1) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0]);
        }
        if (parts.length == 2) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 4) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1], parts[2], parts[3]);
        }
        throw new IllegalArgumentException("bad resource id: " + string);
    }

    public void assertValid() throws IllegalArgumentException {
        try {
            if (RegexCache.isRegexPattern(this.resourceNamespace)) {
                Pattern.compile(this.resourceNamespace);
            }
            if (RegexCache.isRegexPattern(this.resourceName)) {
                Pattern.compile(this.resourceName);
            }
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid resource identifier pattern \"" + String.valueOf(this) + "\" - " + e.getMessage());
        }
    }

    public Optional<ResourceLocation> getLocation() {
        try {
            return Optional.of(SFMResourceLocation.fromNamespaceAndPath(this.resourceNamespace, this.resourceName));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    public boolean matchesStack(Object other) {
        ResourceType<STACK, ITEM, CAP> resourceType = this.getResourceType();
        return resourceType != null && resourceType.matchesStack(this, other);
    }

    public List<ResourceIdentifier<STACK, ITEM, CAP>> expand() {
        try {
            if (this.getResourceType() == SFMResourceTypes.FORGE_ENERGY.get()) {
                return List.of(new ResourceIdentifier<STACK, ITEM, CAP>(this.resourceTypeNamespace, this.resourceTypeName, "forge", "energy"));
            }
            if (expansionCache.containsKey(this)) {
                return expansionCache.get(this);
            }
            ResourceType<STACK, ITEM, CAP> resourceType = this.getResourceType();
            if (resourceType == null) {
                return List.of(this);
            }
            List<ResourceIdentifier<STACK, ITEM, CAP>> rtn = resourceType.getRegistryKeys().stream().filter(this::matchesResourceLocation).map(e -> new ResourceIdentifier<STACK, ITEM, CAP>(this.resourceTypeNamespace, this.resourceTypeName, e.getNamespace(), e.getPath())).toList();
            expansionCache.put(this, rtn);
            return rtn;
        }
        catch (NotImplementedException e2) {
            return List.of(this);
        }
        catch (ResourceLocationException e3) {
            return List.of(this);
        }
    }

    public void setResourceTypeCache(@Nullable ResourceType<STACK, ITEM, CAP> resourceTypeCache) {
        this.resourceTypeCache = resourceTypeCache;
    }

    public ResourceLocation getResourceTypeId() {
        return SFMResourceLocation.fromNamespaceAndPath(this.resourceTypeNamespace, this.resourceTypeName);
    }

    @Nullable
    public ResourceType<STACK, ITEM, CAP> getResourceType() {
        if (this.resourceTypeCache == null) {
            this.setResourceTypeCache(SFMResourceTypes.fastLookup(this.getResourceTypeId()));
        }
        return this.resourceTypeCache;
    }

    public String toString() {
        return this.resourceTypeNamespace + ":" + this.resourceTypeName + ":" + this.resourceNamespace + ":" + this.resourceName;
    }

    @Override
    public String toStringCondensed() {
        boolean isRegexNamespace = RegexCache.isRegexPattern(this.resourceNamespace);
        boolean isRegexNamespaceMatchAll = this.resourceNamespace.equals(".*");
        boolean isRegexName = RegexCache.isRegexPattern(this.resourceName);
        boolean isRegexNameMatchAll = this.resourceName.equals(".*");
        boolean isSFMMod = this.resourceTypeNamespace.equals("sfm");
        boolean isItemType = this.resourceTypeName.equals("item");
        boolean isForgeEnergyType = this.resourceTypeName.equals("forge_energy") && this.getLocation().filter(rl -> rl.equals((Object)SFMResourceLocation.fromNamespaceAndPath("forge", "energy"))).isPresent();
        String resourceNamespaceAlias = isForgeEnergyType ? "fe" : this.resourceNamespace;
        boolean shouldQuoteResult = false;
        StringBuilder rtn = new StringBuilder();
        if (!isSFMMod) {
            rtn.append(this.resourceTypeNamespace).append(":");
        }
        if (!isItemType) {
            rtn.append(this.resourceTypeName).append(":");
        }
        if (isRegexNamespaceMatchAll) {
            if (!isItemType) {
                rtn.append(":");
            }
        } else {
            rtn.append(resourceNamespaceAlias).append(":");
            if (isRegexNamespace) {
                shouldQuoteResult = true;
            }
        }
        if (!isRegexNameMatchAll) {
            rtn.append(this.resourceName);
            if (isRegexName) {
                shouldQuoteResult = true;
            }
        }
        if (shouldQuoteResult) {
            return "\"" + String.valueOf(rtn) + "\"";
        }
        return rtn.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceIdentifier that = (ResourceIdentifier)o;
        return Objects.equals(this.resourceTypeNamespace, that.resourceTypeNamespace) && Objects.equals(this.resourceTypeName, that.resourceTypeName) && Objects.equals(this.resourceNamespace, that.resourceNamespace) && Objects.equals(this.resourceName, that.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.resourceTypeNamespace, this.resourceTypeName, this.resourceNamespace, this.resourceName);
    }

    public boolean usesRegex() {
        return RegexCache.isRegexPattern(this.resourceNamespace) || RegexCache.isRegexPattern(this.resourceName);
    }
}

